package gov.va.vinci.dart.db.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.biz.Role;
import gov.va.vinci.dart.db.RoleDAO;

public class RoleDAOMock implements RoleDAO {
	private static final HashMap<Integer,Role> IDHash = new HashMap<Integer,Role>();
	
	private static boolean initialized = false;

	@Override
	public Role findById(int roleId) throws ObjectNotFoundException {
		initializeRoleHash();

		Role result = IDHash.get(roleId);
		
		if (result == null) {
			throw new ObjectNotFoundException();
		}

		return result;
	}

	@Override
	public List<Role> listAll() {
		List<Role> result = new ArrayList<Role>();
		
		initializeRoleHash();
		
		for (Integer id: IDHash.keySet()) {
			result.add(IDHash.get(id));
		}

		return result;	
	}

	private void initializeRoleHash() {
		if (initialized == true) {
			return;
		}
		
		initialized = true;
		
		Role role = new Role();
		role.setId(1);
		role.setName("reviewer");
		role.setDescription("Reviewer");
		IDHash.put(role.getId(), role);
		
		role = new Role();
		role.setId(2);
		role.setName("admin");
		role.setDescription("Administrator");
		IDHash.put(role.getId(), role);

		role = new Role();
		role.setId(3);
		role.setName("superuser");
		role.setDescription("Super User");
		IDHash.put(role.getId(), role);

		role = new Role();
		role.setId(4);
		role.setName("irma");
		role.setDescription("NDS Administrator");
		IDHash.put(role.getId(), role);
		
		role = new Role();
		role.setId(5);
		role.setName("staff");
		role.setDescription("Read-only Staff");
		IDHash.put(role.getId(), role);
	}
	
}
